import type { APIGatewayProxyHandler } from 'aws-lambda'
// @ts-ignore
import { env } from '$amplify/env/get-all-statewide-services';
import { DynamoDBClient } from "@aws-sdk/client-dynamodb";
import {
  DynamoDBDocumentClient,
  ScanCommand,
} from "@aws-sdk/lib-dynamodb";

const client = new DynamoDBClient({});

const dynamo = DynamoDBDocumentClient.from(client);

/**
 * AWS Lambda function to capture and return all 
 * published statewide services.
 *
 * Used to expose all services publically so that
 * guest users can view services on the app/web page
 * of the trip planner.
 *
 * __*Changes to the returned object may affect apps/web.  Ensure that both schemas match before publishing changes*__
 */
export const handler: APIGatewayProxyHandler = async (event) => {
  try {
    const res = await dynamo.send(
      new ScanCommand({
        TableName: env.BACKEND_STATEWIDE_SERVICES_DYNAMOBD_TABLENAME,
        Select: "SPECIFIC_ATTRIBUTES",
        ProjectionExpression: "agencyid, alias, message, #url, phone",
        FilterExpression: '#status = :status',
        ExpressionAttributeNames: {
          "#status": "status",
          "#url": "url",
        },
        ExpressionAttributeValues: {
          ':status': 'PUBLISHED'
        },
      })
    )

    return {
      statusCode: 200,
      headers: {
        "Access-Control-Allow-Origin": env.BACKEND_REST_API_ALLOWED_ORIGIN,
        "Access-Control-Allow-Headers": env.BACKEND_REST_API_ALLOWED_HEADERS,
        "Access-Control-Allow-Methods": env.BACKEND_REST_API_ALLOWED_METHODS,
      },
      body: JSON.stringify({
        data: res.Items,
        count: res.Count,
      }),
    }

  } catch (e) {
    return {
      statusCode: 500,
      headers: {
        "Access-Control-Allow-Origin": env.BACKEND_REST_API_ALLOWED_ORIGIN,
        "Access-Control-Allow-Headers": env.BACKEND_REST_API_ALLOWED_HEADERS,
        "Access-Control-Allow-Methods": env.BACKEND_REST_API_ALLOWED_METHODS,
      },
      body: JSON.stringify({
        error: e,
      }),
    }
  }
}

